[Setup]
;-- Main Setup Information
 AppName                = Project Epsilon
 AppVerName             = Project Epsilon 1.0.0.2 (Beta)
 AppCopyright           = Copyright  1995-2004 NetWorkDLS.
 DefaultDirName         = {pf}\NetWorkDLS\Project Epsilon
 DefaultGroupName       = NetWorkDLS\Project Epsilon
 UninstallDisplayIcon   = {app}\Project Epsilon.Exe
 UninstallStyle         = Modern
 WizardImageFile        = Resources\LgSetup.bmp
 WizardSmallImageFile   = Resources\SmSetup.bmp
 PrivilegesRequired     = PowerUser
 Uninstallable          = Yes
 AppMutex               = Project Epsilon
 LicenseFile            = Resources\EULA.txt
 Compression            = ZIP/9
 ChangesAssociations    = Yes
 OutputBaseFilename     = i386Beta

;-- Windows 2000 & XP (Support Dialog)
 AppPublisher    = NetWorkDLS
 AppPublisherURL = http://www.NetWorkDLS.com/
 AppUpdatesURL   = http://www.NetWorkDLS.com/
 AppVersion      = 1.0.0.2 (Beta)

[Types]
 Name: "Full";    Description: "Full installation"
 Name: "Compact"; Description: "Compact installation"
 Name: "Custom";  Description: "Custom installation"; Flags: iscustom

[Components]
 Name: "Main";          Description: "Main Files";  Types: Full Compact Custom; Flags: fixed;
 Name: "DLL";           Description: "DLL Files";   Types: Full Compact Custom; Flags: fixed;

[Files]
 Source: "..\Debug\Project Epsilon.Exe";   DestDir: "{app}"; Flags: IgnoreVersion;  Components: Main;
 Source: "Resources\EULA.txt";             DestDir: "{app}"; Flags: IgnoreVersion;  Components: Main;
 Source: "ShellExt\Release\ShellExt.Dll";  DestDir: "{app}"; Flags: RestartReplace; Components: DLL;
 Source: "Libraries\NSWFL.Dll";            DestDir: "{app}"; Flags: IgnoreVersion;  Components: DLL;
 Source: "Libraries\NASCCL.Dll";           DestDir: "{app}"; Flags: IgnoreVersion;  Components: DLL;

[Icons]
 Name: "{group}\Project Epsilon";          Filename: "{app}\Project Epsilon.Exe";    Components: Main
 Name: "{group}\Uninstall";                Filename: "{uninstallexe}";               Components: Main

[Registry]
;-- Create file type association
 Root: HKCR; Subkey: ".PCE"; Flags: uninsdeletekey;
 Root: HKCR; Subkey: ".PCE"; ValueType: string;  ValueData: "Project Epsilon File"
 Root: HKCR; Subkey: "Project Epsilon File"; Flags: uninsdeletekey;
 Root: HKCR; Subkey: "Project Epsilon File"; ValueType: string;  ValueData:"Project Epsilon Encrypted Package"
 Root: HKCR; Subkey: "Project Epsilon File\Shell\Open\Command"; Flags: uninsdeletekey;
 Root: HKCR; Subkey: "Project Epsilon File\Shell\Open\Command"; ValueType: string;  ValueData:"""{app}\Project Epsilon.Exe"" %1"
 Root: HKCR; Subkey: "Project Epsilon File\DefaultIcon"; Flags: uninsdeletekey;
 Root: HKCR; Subkey: "Project Epsilon File\DefaultIcon"; ValueType: string;  ValueData:"{app}\Project Epsilon.Exe,0"

 Root: HKCR; Subkey: "Project Epsilon File\Shell\CreateSelf"; ValueType: string;  ValueData: "Create Self Extractor";
 Root: HKCR; Subkey: "Project Epsilon File\Shell\CreateSelf\Command"; Flags: uninsdeletekey;
 Root: HKCR; Subkey: "Project Epsilon File\Shell\CreateSelf\Command"; ValueType: string;  ValueData:"""{app}\SelfAppend.Exe"" %1";

;-- Create shell extension values
 Root: HKCR; Subkey: "CLSID\{{3dc8ff6a-9aea-42a5-8d23-9e294bac33e5}";                ValueType: string;  ValueData: "Project Epsilon Shell Extension"; Flags: uninsdeletekey;
 Root: HKCR; Subkey: "CLSID\{{3dc8ff6a-9aea-42a5-8d23-9e294bac33e5}\InProcServer32"; ValueType: string;  ValueData: "{app}\ShellExt.Dll";
 Root: HKCR; Subkey: "CLSID\{{3dc8ff6a-9aea-42a5-8d23-9e294bac33e5}\InProcServer32"; ValueType: string;  ValueName: "ThreadingModel"; ValueData:"Apartment"

 Root: HKCR; Subkey: "*\shellex\ContextMenuHandlers\PCEHandler"; ValueType: string;  ValueData:"{{3dc8ff6a-9aea-42a5-8d23-9e294bac33e5}"; Flags: uninsdeletekey;

 Root: HKCR; Subkey: "directory\shellex\ContextMenuHandlers\PCEHandler"; ValueType: string;  ValueData:"{{3dc8ff6a-9aea-42a5-8d23-9e294bac33e5}"; Flags: uninsdeletekey;

 Root: HKLM; Subkey: "SOFTWARE\Microsoft\Windows\CurrentVersion\Shell Extensions\Approved"; ValueType: string;  ValueName: "{{3dc8ff6a-9aea-42a5-8d23-9e294bac33e5}"; ValueData:"Project Epsilon Shell Extension"; Flags: deletevalue;

;------------------------------------------------------------------------------------------------------------------------

 Root: HKLM; Subkey: "Software\NetWorkDLS\Project Epsilon"; Flags: uninsdeletekey;

 ;-- Create Path Keys For Use Within Project Epsilon
 Root: HKLM; Subkey: "Software\NetWorkDLS\Project Epsilon\Path";
 Root: HKLM; Subkey: "Software\NetWorkDLS\Project Epsilon\Path"; ValueType: string;  ValueName: "Path";              ValueData:"{app}";                        Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\Project Epsilon\Path"; ValueType: string;  ValueName: "Project Epsilon";   ValueData:"{app}\Project Epsilon.Exe";    Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\Project Epsilon\Path"; ValueType: string;  ValueName: "MenuIcon";          ValueData:"{app}\MenuIcon.Bmp";           Flags: CreateValueIfDoesntExist;

